/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.JoinedTable;
import com.mckoi.database.Table;
import com.mckoi.util.BlockIntegerList;
import com.mckoi.util.IntegerVector;

public class VirtualTable
extends JoinedTable {
    protected IntegerVector[] row_list;
    private int row_count;

    protected void init(Table[] tables) {
        super.init(tables);
        int table_count = tables.length;
        this.row_list = new IntegerVector[table_count];
        for (int i = 0; i < table_count; ++i) {
            this.row_list[i] = new IntegerVector();
        }
    }

    VirtualTable(Table[] tables) {
        super(tables);
    }

    VirtualTable(Table table) {
        super(table);
    }

    protected VirtualTable() {
    }

    protected IntegerVector[] getReferenceRows() {
        return this.row_list;
    }

    public int getRowCount() {
        return this.row_count;
    }

    void set(Table table, IntegerVector rows) {
        this.row_list[0] = new IntegerVector(rows);
        this.row_count = rows.size();
    }

    void set(Table[] tables, IntegerVector[] rows) {
        for (int i = 0; i < tables.length; ++i) {
            this.row_list[i] = new IntegerVector(rows[i]);
        }
        if (rows.length > 0) {
            this.row_count = rows[0].size();
        }
    }

    void set(Table table, BlockIntegerList rows) {
        this.row_list[0] = new IntegerVector(rows);
        this.row_count = rows.size();
    }

    void set(Table[] tables, BlockIntegerList[] rows) {
        for (int i = 0; i < tables.length; ++i) {
            this.row_list[i] = new IntegerVector(rows[i]);
        }
        if (rows.length > 0) {
            this.row_count = rows[0].size();
        }
    }

    protected int resolveRowForTableAt(int row_number, int table_num) {
        return this.row_list[table_num].intAt(row_number);
    }

    protected void resolveAllRowsForTableAt(IntegerVector row_set, int table_num) {
        IntegerVector cur_row_list = this.row_list[table_num];
        for (int n = row_set.size() - 1; n >= 0; --n) {
            int aa = row_set.intAt(n);
            int bb = cur_row_list.intAt(aa);
            row_set.setIntAt(bb, n);
        }
    }
}

